{ Install utility for MS Excel Add-Ins }
{ Copyright (c) Edgar Goettel 2008 - 2013 }
{ Version 1.10 last change 2013-04-11 }
program AddInInst;

{$APPTYPE CONSOLE}

uses
  SysUtils, Classes, InstConst, InstCheck, InstFunc;

var
  BeQuiet: Boolean = False;
  DoRemove: Boolean = False;
  Auto: Boolean = False;
  About: Boolean = False;
  Version: Double = 0;
  AddIn: String;

function GetParams: Boolean;
var
  i, j: Integer;
  s, t: String;
  d: Double;
begin
  Result:= False;
  AddIn:= '';
  if ParamCount = 0 then Exit;
  for i:=1 to ParamCount do begin
    s:= ParamStr(i);
    if Length(s) = 1 then Continue;
    if s[1] in ['/', '-'] then begin
      case s[2] of
        'A', 'a': DoRemove:= False; // Add Add-In
        'R', 'r': DoRemove:= True;  // Remove Add-In
        'C', 'c': Auto:= True; // COM-Server as Automation Add-In
        'Q', 'q': BeQuiet:= True;   // Quiet Mode
        'V', 'v': begin             // Excel version
                    if Length(s) = 2 then
                      Continue;
                    t:= Copy(s, 3, Length(s) - 2);
                    val(t, d, j);
                    if j = 0 then
                       Version:= d
                    else begin
                      case t[1] of
                        'A', 'a': Version:= 0;  // all installed
                        'L', 'l': Version:=-1;  // latest
                      end;
                    end;
                  end;
      end;
    end else
      if AddIn = '' then
        AddIn:= s
      else
        AddIn:= AddIn + ' ' + s;
  end;
  if AddIn <> '' then begin
    if AddIn[1] = '"' then
      Delete(AddIn, 1, 1);
    if AddIn[Length(AddIn)] = '"' then
      Delete(AddIn, Length(AddIn), 1);
    Result:= True;
  end;
end;

procedure WriteLine(s: String);
begin
  if not BeQuiet then
    Writeln(s);
end;

procedure DoSomething;
var
  Versions: TStrings;
  i, j, res: Integer;
  d: Double;
begin
  if not DoRemove then
    if Auto then begin
      if not CheckCOMServer(AddIn) then begin
        WriteLine(AIIClass);
        Exit;
      end;
    end else
      if ExtractFileDrive(AddIn) = '' then begin
        WriteLine(AIIPath);
        Exit;
      end;
  Versions:= TStringList.Create;
  try
    GetExcelVersions(Versions);
    if Versions.Count > 0 then begin
      if Version = -1 then begin // latest version
        for i:=0 to Versions.Count - 1 do begin
          Val(Versions[i], d, j);
          if d > Version then
            Version:= d;   // set to latest version
        end;
      end;
      if Version > 0 then begin // only specific version
        i:= 0;
        while i < Versions.Count do begin
          Val(Versions[i], d, j);
          if Abs(Version-d) < 0.001 then
            inc(i)
          else
            Versions.Delete(i); // delete all others
        end;
      end;
      if Versions.Count > 0 then begin
        for i:=0 to Versions.Count-1 do begin
          res:= Install(DoRemove, AddIn, Versions[i], Auto);
          case res of
            -1: WriteLine(AIIInvalid);
            0 : if DoRemove then
                  WriteLine('Excel '+ Versions[i] + ': ' + AIISuccR)
                else
                  WriteLine('Excel '+ Versions[i] + ': ' + AIISuccA);
            1 : WriteLine('Excel '+ Versions[i] + ': ' + AIIFail1);
            2 : WriteLine(AIIFail2);
            3 : WriteLine(AIIFail3);
            4 : WriteLine(AIIFail4);
          end;
          if not (res in [0,1]) then Break;
        end;
      end else
        WriteLine(AIIExcel3);
    end else
      WriteLine(AIIExcel2);
  finally
    Versions.Free;
  end;
end;

begin
  if GetParams then
    if Auto or DoRemove or FileExists(AddIn) then
      if not MultiInstance then
        if not ExcelIsRunning then
          DoSomething
        else
          WriteLine(AIIExcel)
      else
        WriteLine(AIIInstance)
    else
      if About then
        WriteLine(AIIHelp)
      else
        WriteLine(AIIFile)
  else
    WriteLine(AIIHelp);
end.
